(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3007,         81]*)
(*NotebookOutlinePosition[      3649,        103]*)
(*  CellTagsIndexPosition[      3605,         99]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Graphics`ComplexMap`\)], "Input"],

Cell[BoxData[
    StyleBox[\(\(\n\)\(\(f[z_]\  := \ z^2;\)\n
      \(f1\  = \ 
          CartesianMap[
            f, {0, 2,  .2}, {\(-4\), 
              4,  .2}, \n\ \ \ \ \ DefaultFont\  -> \ {"\<HelveticaBold\>", 
                16}, \n\ \ \ \ \ AxesStyle\  -> \ 
              Thickness[ .005], \n\ \ \ \ \ Ticks\  -> {{\(-16\), \(-12\), \
\(-8\), \(-4\), 4}, \n\ \ \ \ \ {\(-16\), \(-12\), \(-8\), \(-4\), 4, 8, 12, 
                  16}}];\)\n
      \(f2\  = \ 
          CartesianMap[
            f, {0, 4,  .2}, {\(-2\), 
              2,  .2}, \n\ \ \ \ \ DefaultFont\  -> \ {"\<HelveticaBold\>", 
                16}, \n\ \ \ \ \ AxesStyle\  -> \ 
              Thickness[ .005], \n\ \ \ \ \ Ticks\  -> {{\(-16\), \(-12\), \
\(-8\), \(-4\), 4, 8, 12, 16}, \n\ \ \ \ \ {\(-16\), \(-12\), \(-8\), \(-4\), 
                  4}}];\)\n\ \ \ \ \ \n
      \(Show[f1, f2, 
          Ticks\  -> {{\(-16\), \(-12\), \(-8\), \(-4\), 4, 8, 12, 
                16}, \n\ \ \ \ \ {\(-16\), \(-12\), \(-8\), \(-4\), 4, 8, 12, 
                16}}];\)\n\n
      \(PolarMap[f, {2,  .2}, {\(-Pi\)/2 + Pi/24, Pi/2 - Pi/24, Pi/24}];\)\n
      \)\),
      FormatType->StandardForm,
      FontFamily->"Courier New",
      FontSize->10]], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 56, 1, 30, "Input"],
Cell[1764, 53, 1239, 26, 299, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

